<?php
$service = getContent('service.content',true);
$services = App\Models\Service::where('status',1)->orderBy('created_at','desc')->take(6)->get();
?>
<!-- ==================== Service Start Here ==================== -->
<section class="service-area section-bg py-80 ">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="section-heading  text-center">
                    <span class="subtitle"><?php echo e(__($service->data_values->top_heading)); ?></span>
                    <h2 class="section-heading__title"><?php echo e(__($service->data_values->heading)); ?></h2>
                    <p class="section-heading__desc"><?php echo e(__($service->data_values->sub_heading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row gy-4">
            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-4 col-md-6">

                    <div class="service">
                        <div class="service__icon">
                            <?php echo $item->icon; ?>
                        </div>
                        <div class="service__content mb-3">
                            <h3 class="title">
                                <?php if(strlen(__($item->title)) >50): ?>
                                <?php echo e(substr( __($item->title), 0,50).'...'); ?>

                                <?php else: ?>
                                <?php echo e(__($item->title)); ?>

                                <?php endif; ?>
                            </h3>
                            <p>
                            <?php if(strlen(strip_tags(__($item->description))) > 140): ?>
                            <?php echo e(substr(strip_tags(__($item->description)), 0, 140) . '...'); ?>

                            <?php else: ?>
                                <?php echo e(strip_tags(__($item->description))); ?>

                            <?php endif; ?>
                            </p>
                        </div>
                        <div class="service-bottom-wrap d-flex justify-content-between align-items-center">
                            <p class="price-service"><?php echo e(__($general->cur_sym)); ?> <?php echo e(showAmount($item->price)); ?></p>
                            <a href="<?php echo e(route('service.details', ['slug' => slug($item->title), 'id' => $item->id])); ?>" class="btn btn--base"> <?php echo app('translator')->get('Buy now'); ?> <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<!-- ==================== Service End Here ==================== -->
<?php /**PATH C:\xampp\htdocs\finbiz\application\resources\views/presets/default/sections/service.blade.php ENDPATH**/ ?>