<?php
$contact = getContent('contact_us.content',true);
$socialIcons = getContent('social_icon.element',false);
$languages = App\Models\Language::all();
$pages = App\Models\Page::where('tempname',$activeTemplate)->get();
?>
<!--========================== Header section Start ==========================-->
<div class="header-main-area">

    <div class="header-top">
        <div class="container-fluid">
            <div class="top-header-wrapper">
                <div class="top-contact">
                    <ul class="contact-list">
                        <li class="contact-list__item"> <span class="contact-list__item-icon"><i class="fas fa-phone"></i></span><a href="tel:<?php echo e($contact->data_values->contact_number); ?>" class="contact-list__link"><?php echo e(__($contact->data_values->contact_number)); ?></a></li>
                        <li class="contact-list__item"> <span class="contact-list__item-icon"><i class="fas fa-envelope"></i></span><a href="mailto:<?php echo e($contact->data_values->email_address); ?>" class="contact-list__link"><?php echo e(__($contact->data_values->email_address)); ?></a></li>
                    </ul>
                </div>
                <div class="top-button">
                    <div class="language-box">
                        <select class="langSel select">
                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($language->code); ?>" <?php if(Session::get('lang')===$language->code): ?>
                                selected <?php endif; ?>><?php echo e(__($language->name)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <ul class="login-registration-list d-flex flex-wrap justify-content-between align-items-center ms-2">
                        <li class="login-registration-list__item">
                            <ul class="social-list">
                                <?php $__currentLoopData = $socialIcons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="social-list__item"><a href="<?php echo e(__($item->data_values->url)); ?>" class="social-list__link" target="_blank"><?php echo $item->data_values->social_icon ?></a> </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="header" id="header">
        <div class="container-fluid position-relative">
            <div class="row">
                <div class="header-wrapper">

                    <div class="logo-wrapper">

                            <a href="<?php echo e(route('home')); ?>" class="normal-logo"> <img src="<?php echo e(getImage(getFilePath('logoIcon').'/logo.png', '?'
                                .time())); ?>" alt="<?php echo e(config('app.name')); ?>"></a>

                            <a href="<?php echo e(route('home')); ?>" class="dark-logo hidden"  > <img src="<?php echo e(getImage(getFilePath('logoIcon').'/logo_white.png', '?'
                                    .time())); ?>" alt="<?php echo e(config('app.name')); ?>"></a>
                    </div>

                    <div class="menu-wrapper">
                        <ul class="main-menu">
                            <?php if(auth()->guard()->check()): ?>
                            <li>
                                <a class="nav-link <?php echo e(Route::is('user.home') ? 'active' : ''); ?>" aria-current="page" href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
                            </li>
                            <?php endif; ?>
                            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a class="nav-link <?php echo e(Request::url() == url('/').'/'.$page->slug ? 'active' : ''); ?>" aria-current="page" href="<?php echo e(route('pages',[$page->slug])); ?>"><?php echo e(__($page->name)); ?></a>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>

                    <div class="menu-right-wrapper">
                        <ul>
                            <li></li>
                            <li>
                                <div class="light-dark-btn-wrap ms-1" id="light-dark-checkbox">
                                    <i class="fas fa-moon mon-icon"></i>
                                    <i class='fas fa-sun sun-icon'></i>
                                </div>
                            </li>
                            <?php if(auth()->guard()->check()): ?>
                            <li><a class='btn btn--base' href="<?php echo e(route('user.logout')); ?>"><i class="fas fa-sign-out-alt"></i> <?php echo app('translator')->get('Logout'); ?></a></li>

                            <?php else: ?>
                            <li><a class='btn btn--base' href="<?php echo e(route('user.login')); ?>"><i class="fas fa-sign-in-alt"></i> <?php echo app('translator')->get('Login'); ?></a></li>
                            <?php endif; ?>
                            <li><i class="fas fa-bars sidebar-menu-show-hide"></i></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<!--========================== Header section End ==========================-->


<!--========================== Sidebar mobile menu wrap Start ==========================-->
<div class="sidebar-menu-wrapper">
    <div class="top-close d-flex align-items-center justify-content-between">
        <div class="header-wrapper">

            <div class="logo-wrapper mb-1">
                <a href="<?php echo e(route('home')); ?>" class="normal-logo"> <img src="<?php echo e(getImage(getFilePath('logoIcon').'/logo.png', '?'
                    .time())); ?>" alt="<?php echo e(config('app.name')); ?>"></a>
                <a href="<?php echo e(route('home')); ?>" class="dark-logo hidden" > <img src="<?php echo e(getImage(getFilePath('logoIcon').'/logo_white.png', '?'
                    .time())); ?>" alt="<?php echo e(config('app.name')); ?>"></a>
            </div>
        </div>
        <i class="fas fa-times close-hide-show"></i>
    </div>
    <ul class="sidebar-menu-list">
        <li class="sidebar-menu-list__item <?php echo e(Route::is('user.home') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('user.home')); ?>" class="sidebar-menu-list__link"><?php echo app('translator')->get('Dashboard'); ?></a>
        </li>
        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li class="sidebar-menu-list__item <?php echo e(Request::url() == url('/').'/'.$page->slug ? 'active' : ''); ?>">
            <a href="<?php echo e(route('pages',[$page->slug])); ?>" class="sidebar-menu-list__link"><?php echo e(__($page->name)); ?></a>
        </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php if(auth()->guard()->check()): ?>
        <li class="sidebar-menu-list__item ">
            <a class="btn btn--base mt-2 mb-2 ms-3" href="<?php echo e(route('user.logout')); ?>"><i class="fas fa-sign-out-alt"></i> <?php echo app('translator')->get('Logout'); ?> </a>
        </li>
        <?php else: ?>
        <li class="sidebar-menu-list__item ">
            <a class="btn btn--base mt-2 mb-2 ms-3" href="<?php echo e(route('user.login')); ?>"><i class="fas fa-user"></i> <?php echo app('translator')->get('Login'); ?> </a>
        </li>

        <?php endif; ?>
    </ul>
</div>
<!--========================== Sidebar mobile menu wrap End ==========================-->
<?php /**PATH C:\xampp\htdocs\finbiz\application\resources\views/presets/default/components/header.blade.php ENDPATH**/ ?>