<?php
$links = getContent('policy_pages.element');
$importantLinks = getContent('footer_important_links.element', false, null, true);
$companyLinks = getContent('footer_company_links.element', false, null, true);
$subscribe = getContent('subscribe.content', true);
$contact = getContent('contact_us.content',true);
$socialIcons = getContent('social_icon.element',false);
?>
<!-- ==================== Footer Start Here ==================== -->
<footer class="footer-area section-bg-light bg-img" style="background-image: url(<?php echo e(asset($activeTemplateTrue.'images/footer-bg.jpg')); ?>)">
    <span class="banner-effect-1"></span>
    <div class="pb-60 pt-80">
        <div class="container">
            <div class="row justify-content-center gy-5">
                <div class="col-xl-4 col-sm-6">
                    <div class="footer-item">

                        <div class="footer-item__logo">
                            <a href="<?php echo e(route('home')); ?>" class="footer-logo-normal" id="footer-logo-normal"> <img src="<?php echo e(getImage(getFilePath('logoIcon').'/logo_white.png', '?'
                                .time())); ?>" alt="<?php echo e(config('app.name')); ?>"></a>
                            <a href="<?php echo e(route('home')); ?>" class="footer-logo-dark hidden" id="footer-logo-dark"> <img src="<?php echo e(getImage(getFilePath('logoIcon').'/logo_white.png', '?'
                                .time())); ?>" alt="<?php echo e(config('app.name')); ?>"></a>
                        </div>
                        <p class="footer-item__desc mb-3"><?php echo e(__($contact->data_values->short_description)); ?></p>

                        <ul class="footer-contact-menu">
                            <li class="footer-contact-menu__item">
                                <div class="footer-contact-menu__item-icon">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <div class="footer-contact-menu__item-content">
                                    <p><?php echo e(__($contact->data_values->contact_details)); ?></p>
                                </div>
                            </li>
                            <li class="footer-contact-menu__item">
                                <div class="footer-contact-menu__item-icon">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <div class="footer-contact-menu__item-content">
                                    <p><?php echo e(__($contact->data_values->email_address)); ?></p>
                                </div>
                            </li>
                            <li class="footer-contact-menu__item">
                                <div class="footer-contact-menu__item-icon">
                                    <i class="fas fa-phone"></i>
                                </div>
                                <div class="footer-contact-menu__item-content">
                                    <p><?php echo e(__($contact->data_values->contact_number)); ?></p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-2 col-sm-6">
                    <div class="footer-item">
                        <h5 class="footer-item__title"><?php echo app('translator')->get('Company Links'); ?></h5>
                        <ul class="footer-menu">
                            <?php $__currentLoopData = $companyLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="footer-menu__item"><a href="<?php echo e(url('/').$link->data_values->url); ?>" class="footer-menu__link"><?php echo e($link->data_values->title); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="footer-menu__item"><a href="<?php echo e(route('policy.pages', [slug($link->data_values->title), $link->id])); ?>" class="footer-menu__link"><?php echo e($link->data_values->title); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </ul>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6">
                    <div class="footer-item">
                        <h5 class="footer-item__title"><?php echo app('translator')->get('Important Link'); ?></h5>
                        <ul class="footer-menu">
                            <?php $__currentLoopData = $importantLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="footer-menu__item"><a href="<?php echo e(url('/').$link->data_values->url); ?>" class="footer-menu__link"><?php echo e($link->data_values->title); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6">
                    <div class="footer-item">
                        <h5 class="footer-item__title"><?php echo app('translator')->get('Newsletter'); ?></h5>

                        <p class="footer-item__desc mb-3">
                            <?php if(strlen(__($subscribe->data_values->sub_heading)) >50): ?>
                            <?php echo e(substr( __($subscribe->data_values->sub_heading), 0,50).'...'); ?>

                            <?php else: ?>
                            <?php echo e(__($subscribe->data_values->sub_heading)); ?>

                            <?php endif; ?>
                        </p>

                        <form action="<?php echo e(route('subscribe')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="search-box footer-area w-100">
                                <input type="text" class="form--control" name="email" placeholder="Email...">
                                <button type="submit" class="btn btn--base btn--sm"><?php echo app('translator')->get('Subscribe'); ?></button>
                            </div>
                        </form>

                        <ul class="social-list">
                            <?php $__currentLoopData = $socialIcons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="social-list__item"><a href="<?php echo e(__($item->data_values->url)); ?>" class="social-list__link" target="_blank"><?php echo $item->data_values->social_icon ?></a> </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
  <!-- Footer Top End-->

    <!-- bottom Footer -->
    <div class="bottom-footer section-bg py-3">
        <div class="container">
            <div class="row gy-2">
                <div class="col-lg-6 col-md-12">
                    <div class="bottom-footer-text"><?php echo $contact->data_values->website_footer ?></div>
                </div>
                <div class="col-lg-6 col-md-12">
                    <div class="bottom-footer-menu">
                        <ul>
                            <?php $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e(route('policy.pages', [slug($link->data_values->title), $link->id])); ?>" target="_blank"><?php echo e($link->data_values->title); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e(url('/cookie-policy')); ?>" target="_blank"><?php echo app('translator')->get('Cookie Policy'); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
  </footer>
  <!-- ==================== Footer End Here ==================== -->
<?php /**PATH C:\xampp\htdocs\finbiz\application\resources\views/presets/default/components/footer.blade.php ENDPATH**/ ?>