<?php
$plan = getContent('plan.content',true);
$plans = App\Models\Plan::where('status',1)->orderBy('created_at','desc')->take(3)->get();
?>
<!-- ==================== Pricing Start Here ==================== -->
<section class="pricing-plan py-80">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="section-heading  text-center">
                    <span class="subtitle"><?php echo e(__($plan->data_values->top_heading)); ?></span>
                    <h2 class="section-heading__title"><?php echo e(__($plan->data_values->heading)); ?></h2>
                    <p class="section-heading__desc"><?php echo e(__($plan->data_values->sub_heading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row gy-4 justify-content-center">
            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-4 col-md-6">
                <div class="pricing-plan-item">
                    <img class="price-img-1" src="<?php echo e(asset($activeTemplateTrue.'images/price-top.png')); ?>" alt="image-1">
                    <img class="price-img-2" src="<?php echo e(asset($activeTemplateTrue.'images/price-top.png')); ?>" alt="image-2">
                    <div class="pricing-plan-item__top">
                        <h3 class="title"><?php echo e(__($item->name)); ?></h3>
                    </div>
                    <div class="pricing-plan-item__price">
                        <h3 class="title"><?php echo e(__($general->cur_sym)); ?> <?php echo e(showAmount($item->price)); ?><span><?php echo e($item->type==1 ? '/m' : '/y'); ?></span> </h3>
                    </div>
                    <div class="pricing-plan-item__list">
                        <ul>
                            <?php if(@$item->content): ?>
                               <?php $__currentLoopData = json_decode(@$item->content); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li> <i class="fas fa-check-circle"></i><?php echo e($value); ?></li>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="pricing-plan-item__bottom">
                        <a class="btn btn--base" href="<?php echo e(route('user.payment',$item->id)); ?>">
                           <?php echo app('translator')->get('Get Started'); ?> <i class="fas fa-solid fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<!-- ==================== Pricing End Here ==================== -->
<?php /**PATH C:\xampp\htdocs\finbiz\application\resources\views/presets/default/sections/plan.blade.php ENDPATH**/ ?>