<?php
$about = getContent('about.content',true);
$aboutElements = getContent('about.element',false);
$contact = getContent('contact_us.content',true);

?>
<!--========================== About Section Start ==========================-->
<div class="about-section pt-80 pb-100">
    <div class="container">
        <div class="row flex-wrap-reverse gy-4">
            <div class="col-lg-6">
                <div class="about-thumb">
                    <div class="about-thumb__inner">
                        <img class="img-2" src="<?php echo e(getImage(getFilePath('about').'/'.@$about->data_values->about_image_1)); ?>" alt="image1">
                        <img class="img-1" src="<?php echo e(getImage(getFilePath('about').'/'.@$about->data_values->about_image_2)); ?>" alt="image2">

                        <div class="about-contact d-flex align-items-center">
                            <i class="fas fa-phone"></i>
                            <div class="ms-3">
                                <h4><?php echo app('translator')->get('For Emergency'); ?></h4>
                            <a href="tel:<?php echo e(__($contact->data_values->contact_number)); ?>"><?php echo e(__($contact->data_values->contact_number)); ?></a>
                            </div>
                        </div>
                        <div class="about-contact-top">
                            <h4><?php echo e(__($about->data_values->experience)); ?></h4>
                            <span><?php echo app('translator')->get('Years Of Experience'); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="about-right-content">
                     <div class="section-heading mb-0">
                        <span class="subtitle"><?php echo e(__($about->data_values->top_heading)); ?></span>
                         <h2 class="section-heading__title"><?php echo e(__($about->data_values->heading)); ?></h2>
                         <p class="section-heading__desc mb-3"><?php echo e(__($about->data_values->description)); ?></p>
                         <ul class="about-service mb-4">
                            <?php $__currentLoopData = $aboutElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                             <li>
                                 <span><i class="fas fa-check-circle"></i><?php echo e(__($item->data_values->content_list)); ?></span>
                             </li>
                             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                         </ul>
                         <div class="about-bottom">
                            <a href="<?php echo e(url('/about')); ?>" class="btn btn--base me-3 mb-2">
                                <?php echo e(__($about->data_values->about_btn)); ?>   <?php echo $about->data_values->about_btn_icon; ?>
                            </a>
                         </div>
                     </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--========================== About Section End ==========================-->
<?php /**PATH C:\xampp\htdocs\finbiz\application\resources\views/presets/default/sections/about.blade.php ENDPATH**/ ?>