<?php
    $team =  getContent('team_member.content',true);
    $teamElements = getContent('team_member.element',false);
?>
<!-- ==================== Team Start Here ==================== -->
<section class="team-area py-80">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="section-heading  text-center">
                    <span class="subtitle"><?php echo e(__($team->data_values->top_heading)); ?></span>
                    <h2 class="section-heading__title"><?php echo e(__($team->data_values->heading)); ?></h2>
                    <p class="section-heading__desc"><?php echo e(__($team->data_values->subheading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row gy-4 justify-content-center">
            <?php $__currentLoopData = $teamElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-3 col-md-6">
                <div class="team-item">
                    <div class="team-item__thumb">
                        <img src="<?php echo e(getImage(getFilePath('teamMember').'/'.$item->data_values->agent_image)); ?>" alt="team member">
                    </div>
                    <div class="team-item__content-wrapper">
                        <div class="team-name">
                            <h3>
                                <?php if(strlen(__($item->data_values->title)) >20): ?>
                                        <?php echo e(substr( __($item->data_values->title), 0,20).'...'); ?>

                                    <?php else: ?>
                                        <?php echo e(__($item->data_values->title)); ?>

                                <?php endif; ?>
                            </h3>
                            <span>
                                <?php if(strlen(__($item->data_values->description)) >20): ?>
                                        <?php echo e(substr( __($item->data_values->description), 0,20).'...'); ?>

                                    <?php else: ?>
                                        <?php echo e(__($item->data_values->description)); ?>

                                <?php endif; ?>
                            </span>
                        </div>
                        <div class="social-wrap d-flex align-items-center justify-content-end">
                            <ul class="d-flex">
                                <li> <a href="mailto:<?php echo e($item->data_values->email); ?>" title="<?php echo e(__($item->data_values->email)); ?>"><i class="fas fa-envelope"></i></a>
                                </li>
                                <li class="share__icon"><a href=""><i class="fas fa-share-alt"></i></a>
                                    <ul class="social-team">
                                        <li class="social-list__item"><a href="<?php echo e(__($item->data_values->facebook_link)); ?>" class="social-list__link"><?php echo $item->data_values->facebook_icon; ?></a> </li>
                                        <li class="social-list__item"><a href="<?php echo e(__($item->data_values->twitter_link)); ?>" class="social-list__link active"> <?php echo $item->data_values->twitter_icon; ?></a></li>
                                        <li class="social-list__item"><a href="<?php echo e(__($item->data_values->instagram_link)); ?>" class="social-list__link"> <?php echo $item->data_values->instagram_icon; ?></a></li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<!-- ==================== Team Start Here ==================== -->
<?php /**PATH C:\xampp\htdocs\finbiz\application\resources\views/presets/default/sections/team_member.blade.php ENDPATH**/ ?>