<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Service;
use Illuminate\Http\Request;

class ServiceController extends Controller
{
    public function index(){
        $pageTitle = 'Services';
        $services = Service::orderBy('created_at','desc')->paginate(getPaginate());
        return view('admin.services.index',compact('pageTitle','services'));
    }

    public function create(){
        $pageTitle = 'Add Service';
        return view('admin.services.create',compact('pageTitle'));
    }

    public function edit($id){
        $pageTitle = 'Update';
        $service = Service::findOrFail($id);
        return view('admin.services.edit',compact('pageTitle','service'));

    }

    public function store(Request $request){
        $request->validate([
            'title'=>'required',
            'icon'=>'required',
        ]);


        $service = new Service();
        $service->title = $request->title;
        $service->icon = $request->icon;
        $service->description = $request->description;
        $service->status = 1;
        $service->save();

        $notify[] = ['success', 'Service has been created successfully'];
        return back()->withNotify($notify);

    }

    public function update(Request $request,$id){
        $request->validate([
            'title'=>'required',
            'icon'=>'required',
        ]);

        $service = Service::find($id);
        $service->title = $request->title;
        $service->icon = $request->icon;
        $service->description = $request->description;
        $service->status = $request->status ? 1 : 0;
        $service->save();

        $notify[] = ['success', 'Service has been updated successfully'];
        return to_route('admin.service.index')->withNotify($notify);

    }

    public function delete(Request $request){
        $service = Service::findOrFail($request->id);
        $service->delete();
        $notify[] = ['error', 'Service has been deleted'];
        return back()->withNotify($notify);
    }
}
