@extends('admin.layouts.app')
@section('panel')

<div class="row mb-none-30">
    <div class="col-lg-12 mb-30">
        <div class="card">
            <div class="card-body">
                <form action="{{route('admin.service.update',$service->id)}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="title" class="font-weight-bold">@lang('Title')</label>
                                <input type="text" name="title" id="title" value="{{$service->title}}"
                                    class="form-control" required>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="icon" class="font-weight-bold">@lang('Icon')</label>
                                <div class="input-group">
                                    <input type="text" class="form-control iconPicker icon" autocomplete="off"
                                        name="icon" value="{{$service->icon}}" required>
                                    <span class="input-group-text  input-group-addon" data-icon="las la-home"
                                        role="iconpicker">@php echo $service->icon @endphp</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="type" class="font-weight-bold">@lang('Description')</label>
                                <textarea class="trumEdit" name="description"
                                placeholder="@lang('Description')" id="new_pass"  cols="40"
                                rows="10">@php echo $service->description; @endphp</textarea>
                            </div>
                        </div>
                        <div class="col-lg-2">
                            <label class="fw-bold">@lang('Status')</label>
                            <label class="switch m-0">
                                <input type="checkbox" class="toggle-switch" name="status" {{ $service->status ?
                                'checked' : null }}>
                                <span class="slider round"></span>
                            </label>
                        </div>
                        <div class="row text-end">
                            <div class="col-lg-12 ">
                                <div class="form-group float-end p-3">
                                    <button type="submit" class="btn btn--primary btn-block btn-lg"> @lang('Update')</button>
                                </div>
                            </div>
                        </div>
                 </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('breadcrumb-plugins')
<a href="{{route('admin.service.index')}}" class="btn btn-sm btn--primary box--shadow1 text--small"><i
        class="las la-angle-double-left"></i>@lang('Go Back')</a>
@endpush


@push('style-lib')
<link href="{{ asset('assets/admin/css/fontawesome-iconpicker.min.css') }}" rel="stylesheet">
@endpush

@push('style')
<style>
    .ck-placeholder{
        height: 190px !important;
    }
</style>
@endpush

@push('script')
<script src="{{ asset('assets/admin/js/fontawesome-iconpicker.js') }}"></script>
<script>
      (function($){
        "use strict";

        $('.iconPicker').iconpicker().on('iconpickerSelected', function (e) {
            $(this).closest('.form-group').find('.iconpicker-input').val(`<i class="${e.iconpickerValue}"></i>`);
        });

    })(jQuery);
</script>
@endpush


